<?php
/**
 * Uninstall handler for Digital Rise WooCommerce Filter Solutions.
 *
 * @package Digital_Rise_WooCommerce_Filter
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

delete_option( 'drwf_settings' );

if ( is_multisite() ) {
    $sites = get_sites( array( 'fields' => 'ids' ) );
    foreach ( $sites as $site_id ) {
        switch_to_blog( $site_id );
        delete_option( 'drwf_settings' );
        restore_current_blog();
    }
}
