<?php
/**
 * AJAX handler for the price + category filter.
 *
 * @package Digital_Rise_WooCommerce_Filter
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'wp_ajax_drwf_filter_products', 'drwf_ajax_filter_products' );
add_action( 'wp_ajax_nopriv_drwf_filter_products', 'drwf_ajax_filter_products' );

/**
 * Process AJAX filter request.
 */
function drwf_ajax_filter_products() {

    if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['nonce'] ) ), 'drwf_filter_nonce' ) ) {
        wp_send_json_error( array(
            'message' => __( 'Security check failed.', 'digital-rise-woocommerce-filter' ),
        ), 403 );
    }

    $options = get_option( 'drwf_settings', drwf_get_defaults() );
    if ( isset( $options['ajax_enabled'] ) && '0' === $options['ajax_enabled'] ) {
        wp_send_json_error( array(
            'message' => __( 'AJAX filtering is disabled.', 'digital-rise-woocommerce-filter' ),
        ) );
    }

    $min_price = isset( $_POST['min_price'] ) ? floatval( $_POST['min_price'] ) : 0;
    $max_price = isset( $_POST['max_price'] ) ? floatval( $_POST['max_price'] ) : 1000;

    if ( $min_price < 0 ) {
        $min_price = 0;
    }
    if ( $max_price < $min_price ) {
        $max_price = $min_price;
    }

    $category_ids = array();
    if ( isset( $_POST['categories'] ) && is_array( $_POST['categories'] ) ) {
        $category_ids = array_map( 'absint', $_POST['categories'] );
        $category_ids = array_filter( $category_ids );
    }

    $scope_cats = array();
    if ( isset( $_POST['scope_cats'] ) && '' !== $_POST['scope_cats'] ) {
        $scope_cats = array_map( 'absint', explode( ',', sanitize_text_field( wp_unslash( $_POST['scope_cats'] ) ) ) );
        $scope_cats = array_filter( $scope_cats );
    }

    if ( empty( $scope_cats ) ) {
        $scope_cats = isset( $options['allowed_categories'] ) ? array_map( 'intval', (array) $options['allowed_categories'] ) : array();
    }

    if ( ! function_exists( 'drwf_get_filtered_products' ) ) {
        require_once DRWF_PLUGIN_DIR . 'includes/shortcode.php';
    }

    $html = drwf_get_filtered_products( $min_price, $max_price, $category_ids, '', $scope_cats );

    wp_send_json_success( array(
        'html' => $html,
    ) );
}
