/**
 * Digital Rise WooCommerce Badge – Admin JS v3.0
 * @version 3.0.0
 */
(function($){
'use strict';

var S={badges:{},cats:DRWB.categories||[],pos:DRWB.positions||{},set:DRWB.settings||{}};
if(DRWB.badges&&typeof DRWB.badges==='object'&&!Array.isArray(DRWB.badges))S.badges=$.extend(!0,{},DRWB.badges);

$(function(){loadG();renderAll();bindG();});

function loadG(){
    $('#drwb-global-enabled').prop('checked',S.set.enabled==='1');
    $('#drwb-force-badge').prop('checked',S.set.force_badge==='1');
    $('#drwb-custom-css').val(S.set.custom_css||'');
}

function bindG(){
    $('#drwb-save-global').on('click',function(){
        var $b=$(this).prop('disabled',!0).text('Saving…'),$s=$('#drwb-global-status');
        $.post(DRWB.ajax_url,{action:'drwb_save_settings',nonce:DRWB.nonce,
            enabled:$('#drwb-global-enabled').is(':checked')?'1':'',
            force_badge:$('#drwb-force-badge').is(':checked')?'1':'',
            custom_css:$('#drwb-custom-css').val()
        }).done(function(r){
            r.success?(S.set=r.data.settings,fl($s,'Saved!','ok')):fl($s,'Error','err');
        }).fail(function(){fl($s,'Network error','err');}).always(function(){$b.prop('disabled',!1).text('Save Settings');});
    });
    $('#drwb-add-badge').on('click',addB);
    $('#drwb-purge').on('click',function(){
        if(!confirm('DELETE ALL badge configurations?'))return;
        $.post(DRWB.ajax_url,{action:'drwb_purge_all',nonce:DRWB.nonce}).done(function(r){
            if(r.success){S.badges={};$('#drwb-list').empty();ck();}
        });
    });
}

function renderAll(){
    var $l=$('#drwb-list').empty(),k=Object.keys(S.badges);
    if(!k.length){ck();return;}
    $('#drwb-empty').hide();
    k.forEach(function(id){var $c=card(id,S.badges[id],!1);$l.append($c);pk($c);});
}

function addB(){
    var tid='new_'+Date.now(),blank={enabled:'1',category:'',text:'',bg:'#e74c3c',color:'#ffffff',position:'top-left',opacity:55,fontsize:14};
    S.badges[tid]=blank;$('#drwb-empty').hide();
    var $c=card(tid,blank,!0);$('#drwb-list').append($c);pk($c);
    $('html,body').animate({scrollTop:$c.offset().top-80},300);
}

function card(id,b,open){
    var on=b.enabled==='1',ovl=b.position==='full-overlay',cat=cn(b.category),
        ttl=b.text?esc(b.text):'<em style="color:#999">Untitled</em>',
        cls='drwb-bc'+(open?' drwb-bc--open':'')+(on?'':' drwb-bc--off')+(ovl?' drwb-bc--ovl':'');

    var h='<div class="'+cls+'" data-id="'+id+'">';
    h+='<div class="drwb-bc__hd">';
    h+='<span class="drwb-bc__dot" style="background:'+(b.bg||'#e74c3c')+'"></span>';
    h+='<span class="drwb-bc__ttl">'+ttl+'<small>'+esc(cat||'No category')+'</small></span>';
    h+='<span class="drwb-bc__pill '+(on?'drwb-bc__pill--on':'drwb-bc__pill--off')+'">'+(on?'Enabled':'Disabled')+'</span>';
    h+='<span class="dashicons dashicons-arrow-down-alt2 drwb-bc__chv"></span></div>';

    h+='<div class="drwb-bc__bd"><div class="drwb-g">';

    // Enable
    h+=gf('<label class="drwb-tog"><input type="checkbox" class="f-en" value="1"'+(on?' checked':'')+'/><span class="drwb-tog__sl"></span><span>Enable this badge</span></label>');

    // Category
    var co='<option value="0">— Select category —</option>';
    S.cats.forEach(function(c){co+='<option value="'+c.id+'"'+(parseInt(b.category)===c.id?' selected':'')+'>'+esc(c.name)+'</option>';});
    h+=gn('Product Category','<select class="f-cat">'+co+'</select>');

    // Text
    h+=gn('Badge Text','<input type="text" class="f-txt" value="'+at(b.text)+'" placeholder="e.g. Vendu, Loué, Indisponible"/>');

    // BG + Color
    h+=gn('Background','<input type="text" class="f-bg drwb-cp" value="'+at(b.bg||'#e74c3c')+'" data-default-color="#e74c3c"/>');
    h+=gn('Text Colour','<input type="text" class="f-col drwb-cp" value="'+at(b.color||'#ffffff')+'" data-default-color="#ffffff"/>');

    // Position
    var po='';$.each(S.pos,function(v,l){po+='<option value="'+v+'"'+(b.position===v?' selected':'')+'>'+esc(l)+'</option>';});
    h+=gn('Position','<select class="f-pos">'+po+'</select>');

    // Font size
    h+=gn('Font Size (px)','<input type="number" class="f-fs" value="'+(b.fontsize||14)+'" min="8" max="60"/>');

    // Opacity
    h+='<div class="drwb-gf drwb-gf--ovl"><label>Overlay Opacity</label>';
    h+='<div class="drwb-rr"><input type="range" class="f-op" min="0" max="100" step="5" value="'+(b.opacity||55)+'"/>';
    h+='<span class="drwb-rv">'+(b.opacity||55)+'%</span></div></div>';

    // Actions
    h+='<div class="drwb-acts">';
    h+='<button type="button" class="button-link-delete btn-del">Delete Badge</button>';
    h+='<div><button type="button" class="button button-primary btn-sav">Save Badge</button>';
    h+='<span class="drwb-sst"></span></div></div>';

    h+='</div></div></div>';

    var $c=$(h);
    $c.find('.drwb-bc__hd').on('click',function(){$c.toggleClass('drwb-bc--open');});
    $c.find('.f-pos').on('change',function(){$c.toggleClass('drwb-bc--ovl',$(this).val()==='full-overlay');});
    $c.find('.f-op').on('input',function(){$(this).siblings('.drwb-rv').text($(this).val()+'%');});
    $c.find('.btn-sav').on('click',function(){sav($c);});
    $c.find('.btn-del').on('click',function(){if(confirm('Delete this badge?'))del($c);});
    return $c;
}

function sav($c){
    var id=$c.attr('data-id'),$b=$c.find('.btn-sav').prop('disabled',!0).text('Saving…'),$s=$c.find('.drwb-sst');
    var d={enabled:$c.find('.f-en').is(':checked')?'1':'',category:$c.find('.f-cat').val(),
        text:$c.find('.f-txt').val(),bg:$c.find('.f-bg').val(),color:$c.find('.f-col').val(),
        position:$c.find('.f-pos').val(),opacity:$c.find('.f-op').val(),fontsize:$c.find('.f-fs').val()};
    $.post(DRWB.ajax_url,{action:'drwb_save_badge',nonce:DRWB.nonce,
        badge_id:id.indexOf('new_')===0?'':id,badge:d
    }).done(function(r){
        if(r.success){S.badges=obj(r.data.all);$c.attr('data-id',r.data.badge_id);uhd($c,r.data.badge);fl($s,'Saved!','ok');}
        else fl($s,'Error','err');
    }).fail(function(){fl($s,'Network error','err');}).always(function(){$b.prop('disabled',!1).text('Save Badge');});
}

function del($c){
    var id=$c.attr('data-id');
    if(id.indexOf('new_')===0){delete S.badges[id];$c.slideUp(200,function(){$(this).remove();ck();});return;}
    $.post(DRWB.ajax_url,{action:'drwb_delete_badge',nonce:DRWB.nonce,badge_id:id}).done(function(r){
        if(r.success){S.badges=obj(r.data.all);$c.slideUp(200,function(){$(this).remove();ck();});}
        else alert('Delete failed');
    }).fail(function(){alert('Network error');});
}

function uhd($c,b){
    $c.find('.drwb-bc__dot').css('background',b.bg||'#e74c3c');
    $c.find('.drwb-bc__ttl').html((b.text?esc(b.text):'<em style="color:#999">Untitled</em>')+'<small>'+esc(cn(b.category)||'No category')+'</small>');
    var on=b.enabled==='1',$p=$c.find('.drwb-bc__pill').removeClass('drwb-bc__pill--on drwb-bc__pill--off');
    $p.addClass(on?'drwb-bc__pill--on':'drwb-bc__pill--off').text(on?'Enabled':'Disabled');
    $c.toggleClass('drwb-bc--off',!on).toggleClass('drwb-bc--ovl',b.position==='full-overlay');
}

function pk($s){$s.find('.drwb-cp').each(function(){if(!$(this).closest('.wp-picker-container').length)$(this).wpColorPicker();});}
function cn(id){id=parseInt(id);for(var i=0;i<S.cats.length;i++)if(S.cats[i].id===id)return S.cats[i].name;return'';}
function ck(){$('#drwb-empty').toggle($('#drwb-list').children().length===0);}
function obj(d){if(!d||typeof d!=='object')return{};if(Array.isArray(d)&&!d.length)return{};return $.extend(!0,{},d);}
function fl($e,m,t){$e.text(m).removeClass('ok err').addClass(t);setTimeout(function(){$e.fadeOut(300,function(){$(this).text('').css('display','').removeClass('ok err');});},2500);}
function esc(s){return s?$('<span>').text(s).html():'';}
function at(s){return(s||'').replace(/&/g,'&amp;').replace(/"/g,'&quot;').replace(/'/g,'&#39;').replace(/</g,'&lt;').replace(/>/g,'&gt;');}
function gn(l,inner){return'<div class="drwb-gf"><label>'+l+'</label>'+inner+'</div>';}
function gf(inner){return'<div class="drwb-gf drwb-gf--full">'+inner+'</div>';}

})(jQuery);
