# Digital Rise WhatsApp Solutions

[![WordPress Plugin Version](https://img.shields.io/badge/WordPress-5.8%2B-blue)](https://wordpress.org/)
[![WooCommerce Version](https://img.shields.io/badge/WooCommerce-6.0%2B-purple)](https://woocommerce.com/)
[![PHP Version](https://img.shields.io/badge/PHP-7.4%2B-777BB4)](https://www.php.net/)
[![License](https://img.shields.io/badge/License-GPLv2%2B-green)](https://www.gnu.org/licenses/gpl-2.0.html)

**Transform your WooCommerce store into a WhatsApp-powered inquiry system.**

Replace traditional checkout with direct WhatsApp contact buttons, perfect for businesses that prefer personal communication before finalizing sales.

---

## 🎯 Perfect For

- **Real Estate Agencies** - Let clients inquire about properties directly
- **Luxury Goods Sellers** - Provide personalized service for high-value items
- **Custom Manufacturers** - Discuss specifications before purchase
- **B2B Businesses** - Enable direct communication with buyers
- **Service Providers** - Convert products into service inquiries
- **Consulting Services** - Use WooCommerce as a service catalog

---

## ✨ Key Features

### 🛒 Complete Checkout Replacement
- Safely disables WooCommerce purchasing without touching core files
- Removes "Add to Cart" buttons site-wide
- Disables cart and checkout pages
- Prevents order creation
- Uses only WooCommerce hooks and filters for maximum safety

### 📱 WhatsApp Integration
- Beautiful green WhatsApp buttons replace cart buttons
- Opens WhatsApp in new tab (app on mobile, web on desktop)
- Pre-filled messages with product URL automatically included
- Supports 200+ country codes
- Multilingual message support

### ⚙️ Easy Configuration
- Simple admin panel under WooCommerce menu
- Country code dropdown selector
- Phone number validation
- Customizable message template
- Live preview of WhatsApp link

### 🎨 Design & Compatibility
- Responsive design for all devices
- Works with any WooCommerce theme
- Compatible with WooCommerce blocks
- Clean, professional styling
- Customizable via CSS

### 🔒 Security & Performance
- XSS protection with proper escaping
- Input sanitization and validation
- HPOS compatible
- No external dependencies
- Minimal database queries
- Assets loaded only when needed

---

## 📦 Installation

### Quick Install

1. **Download & Prepare**
   ```bash
   # Compress the plugin folder
   zip -r digital-rise-whatsapp-solutions.zip digital-rise-whatsapp-solutions/
   ```

2. **Upload to WordPress**
   - Go to **Plugins → Add New → Upload Plugin**
   - Choose the ZIP file
   - Click **Install Now** then **Activate**

3. **Configure**
   - Navigate to **WooCommerce → WhatsApp Settings**
   - Enter your country code and WhatsApp number
   - Customize your message
   - Save settings

### Manual Install via FTP

```bash
# Upload to your WordPress plugins directory
/wp-content/plugins/digital-rise-whatsapp-solutions/
```

Then activate from WordPress admin → Plugins.

See [INSTALLATION.md](INSTALLATION.md) for detailed instructions.

---

## 🚀 Quick Start

1. **Install WooCommerce** (if not already installed)
2. **Install this plugin**
3. **Configure WhatsApp Settings:**
   - Country Code: Select from dropdown (e.g., +216 for Tunisia)
   - Phone Number: Enter without country code (e.g., 98765432)
   - Message: "Je suis intéressé par ce bien immobilier :"
4. **Save and test** - Visit any product page

---

## 📖 Usage

### Basic Usage

Once configured, the plugin works automatically:

- **Single Product Pages**: WhatsApp button replaces Add to Cart
- **Shop Pages**: WhatsApp buttons appear on product grids
- **Category Pages**: WhatsApp buttons on all products
- **Related Products**: WhatsApp buttons included

### Example WhatsApp Message

When a customer clicks the button on a product:

```
Je suis intéressé par ce bien immobilier : https://yoursite.com/product/luxury-villa/
```

The product URL is automatically appended to your message.

### For Developers

The plugin includes helper functions for custom implementations:

```php
// Get WhatsApp number
$number = drws_get_whatsapp_number();
// Returns: +21698765432

// Get message template
$message = drws_get_whatsapp_message();
// Returns: Je suis intéressé par ce bien immobilier :

// Generate WhatsApp URL for a product
$url = drws_get_product_whatsapp_url( $product_id );
// Returns: https://wa.me/21698765432?text=...

// Check if WhatsApp is configured
if ( drws_is_configured() ) {
    // Show WhatsApp features
}

// Display custom button
drws_display_whatsapp_button( $product_id, array(
    'class'      => 'my-custom-class',
    'text'       => 'Chat Now',
    'show_icon'  => true,
    'new_window' => true,
) );
```

---

## 🎨 Customization

### Custom Button Styling

```css
/* Customize button appearance */
.drws-whatsapp-button {
    background-color: #128C7E; /* Darker WhatsApp green */
    padding: 15px 30px;
    font-size: 18px;
}

.drws-whatsapp-button:hover {
    background-color: #075E54; /* Even darker on hover */
}

/* Change icon size */
.drws-whatsapp-icon {
    width: 24px;
    height: 24px;
}
```

### Custom Message Per Product

```php
// Add custom message for specific products
add_filter( 'drws_whatsapp_message', 'custom_whatsapp_message', 10, 2 );
function custom_whatsapp_message( $message, $product_id ) {
    if ( $product_id === 123 ) {
        return 'Special inquiry for this premium product:';
    }
    return $message;
}
```

---

## 🔧 Requirements

- **WordPress**: 5.8 or higher
- **WooCommerce**: 6.0 or higher
- **PHP**: 7.4 or higher
- **WhatsApp**: Active Business or personal account

---

## 🌍 Supported Countries

The plugin includes 200+ country codes including:

- 🇹🇳 Tunisia (+216)
- 🇫🇷 France (+33)
- 🇺🇸 USA/Canada (+1)
- 🇬🇧 UK (+44)
- 🇩🇪 Germany (+49)
- 🇪🇸 Spain (+34)
- 🇮🇹 Italy (+39)
- 🇦🇪 UAE (+971)
- 🇸🇦 Saudi Arabia (+966)
- And many more...

---

## ❓ FAQ

### Does this delete my WooCommerce data?
No. The plugin only disables purchasing functionality. All products, categories, and settings remain intact.

### Can I revert to normal WooCommerce checkout?
Yes. Simply deactivate the plugin and WooCommerce functions normally again.

### Does this work with my theme?
Yes. The plugin uses WooCommerce standard hooks and works with any WooCommerce-compatible theme.

### What happens to the cart and checkout pages?
They automatically redirect to the shop page since they're no longer needed.

### Can I customize the button text?
Yes. You can customize it using CSS or the provided PHP filters.

### Does this work on mobile?
Yes. The button is fully responsive and opens the WhatsApp app on mobile devices.

### Is this compatible with WooCommerce blocks?
Yes. The plugin works with both classic WooCommerce pages and block-based pages.

---

## 🐛 Troubleshooting

### Button Not Showing
1. Ensure you've entered your WhatsApp number in settings
2. Clear site cache
3. Check browser console for errors

### WhatsApp Not Opening
1. Verify your phone number is correct
2. Include country code
3. Test with a known WhatsApp number

### Styling Issues
1. Clear browser cache
2. Check for theme CSS conflicts
3. Use browser inspector to identify issues

---

## 📂 File Structure

```
digital-rise-whatsapp-solutions/
│
├── assets/                          # Plugin assets
│   └── index.php                    # Security file
│
├── includes/                        # Core plugin files
│   ├── class-drws-admin-settings.php   # Admin settings
│   ├── class-drws-frontend.php         # Frontend functionality
│   ├── drws-functions.php              # Helper functions
│   └── index.php                       # Security file
│
├── languages/                       # Translation files
│   ├── digital-rise-whatsapp-solutions.pot
│   └── index.php
│
├── digital-rise-whatsapp-solutions.php  # Main plugin file
├── readme.txt                       # WordPress.org readme
├── uninstall.php                    # Uninstall cleanup
├── INSTALLATION.md                  # Installation guide
├── CHANGELOG.md                     # Version history
└── README.md                        # This file
```

---

## 🔄 Updates

The plugin follows WordPress.org update standards. When updates are available, you'll see them in your WordPress admin → Plugins page.

---

## 🤝 Contributing

This is a production plugin developed for specific business needs. For feature requests or bug reports, contact Digital Rise Solutions.

---

## 📄 License

This plugin is licensed under GPL v2 or later.

```
Digital Rise WhatsApp Solutions
Copyright (C) 2025 Oussama Ben Rejab

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.
```

---

## 👨‍💻 Author

**Oussama Ben Rejab**  
SEO Expert & WordPress Developer  
Digital Rise Solutions

- Website: [digital-rise-solutions.com](https://digital-rise-solutions.com/)
- Author Page: [Oussama Ben Rejab](https://digital-rise-solutions.com/oussama-ben-rejab-seo-expert-seo-consultant/)

---

## 🙏 Credits

Developed with ❤️ by [Digital Rise Solutions](https://digital-rise-solutions.com/)

WhatsApp is a registered trademark of Meta Platforms, Inc.

---

## 📞 Support

For support, questions, or feature requests:

- Visit: [digital-rise-solutions.com](https://digital-rise-solutions.com/)
- Contact via website form

---

**⭐ If you find this plugin useful, please consider leaving a review!**

---

## 📊 Version

**Current Version**: 1.0.0  
**Release Date**: February 10, 2025  
**Status**: Production Ready
