# Digital Rise WhatsApp Solutions - Installation Guide

## Quick Start Guide

### Requirements
- WordPress 5.8 or higher
- WooCommerce 6.0 or higher
- PHP 7.4 or higher
- Active WhatsApp Business or personal account

### Installation Steps

#### Method 1: Direct Upload (Recommended)

1. **Download the Plugin**
   - You have the `digital-rise-whatsapp-solutions` folder

2. **Create ZIP File**
   - Compress the `digital-rise-whatsapp-solutions` folder into a ZIP file
   - On Windows: Right-click folder → Send to → Compressed (zipped) folder
   - On Mac: Right-click folder → Compress "digital-rise-whatsapp-solutions"
   - On Linux: `zip -r digital-rise-whatsapp-solutions.zip digital-rise-whatsapp-solutions/`

3. **Upload to WordPress**
   - Log in to your WordPress admin panel
   - Go to **Plugins → Add New**
   - Click **Upload Plugin** button at the top
   - Click **Choose File** and select your ZIP file
   - Click **Install Now**
   - Click **Activate Plugin**

#### Method 2: FTP Upload

1. **Upload via FTP**
   - Connect to your server via FTP
   - Navigate to `/wp-content/plugins/`
   - Upload the entire `digital-rise-whatsapp-solutions` folder
   - Go to WordPress admin → Plugins
   - Find "Digital Rise WhatsApp Solutions" and click **Activate**

#### Method 3: File Manager (cPanel)

1. **Using cPanel File Manager**
   - Log in to your hosting cPanel
   - Open File Manager
   - Navigate to `public_html/wp-content/plugins/`
   - Upload the ZIP file
   - Extract the ZIP file
   - Go to WordPress admin → Plugins
   - Find "Digital Rise WhatsApp Solutions" and click **Activate**

### Configuration

1. **Access Settings**
   - Go to **WooCommerce → WhatsApp Settings** in your WordPress admin

2. **Configure WhatsApp Number**
   - Select your country code from the dropdown (e.g., +216 for Tunisia)
   - Enter your WhatsApp number WITHOUT the country code
   - Example: If your number is +216 98765432, enter only: 98765432

3. **Customize Message**
   - Enter your default message in the textarea
   - The product URL will be automatically appended
   - Example: "Je suis intéressé par ce bien immobilier :"
   - Supports any language and special characters

4. **Save Settings**
   - Click **Save Settings** button
   - You'll see a preview of your complete WhatsApp number

### Verification

After installation and configuration:

1. **Check Single Product Page**
   - Visit any product page on your site
   - You should see a green "Contact via WhatsApp" button
   - The "Add to Cart" button should be gone

2. **Check Shop Page**
   - Visit your shop page
   - Each product should have a WhatsApp button
   - No cart buttons should be visible

3. **Test the Button**
   - Click on a WhatsApp button
   - It should open WhatsApp (app or web)
   - Your message should be pre-filled
   - The product URL should be included

4. **Test Cart/Checkout Redirect**
   - Try to access yoursite.com/cart/
   - It should redirect to the shop page
   - Try to access yoursite.com/checkout/
   - It should also redirect to the shop page

### Troubleshooting

#### Plugin Won't Activate
- **Error:** "Digital Rise WhatsApp Solutions requires WooCommerce"
- **Solution:** Install and activate WooCommerce first

#### WhatsApp Button Not Showing
- **Check:** Make sure you've entered your WhatsApp number in settings
- **Check:** Clear your site cache (if using a caching plugin)
- **Check:** Try a different browser or incognito mode

#### Button Not Styling Correctly
- **Check:** Make sure WooCommerce styles are loading
- **Solution:** Go to Appearance → Customize → WooCommerce and ensure styles are enabled
- **Solution:** Clear your browser cache

#### WhatsApp Opens But Message Is Wrong
- **Check:** Go to WooCommerce → WhatsApp Settings
- **Check:** Verify your message template
- **Check:** Save settings again

### Deactivation

If you want to return to normal WooCommerce functionality:

1. Go to **Plugins** in WordPress admin
2. Find "Digital Rise WhatsApp Solutions"
3. Click **Deactivate**
4. WooCommerce will immediately return to normal checkout functionality

### Uninstallation

To completely remove the plugin:

1. **Deactivate** the plugin first
2. Click **Delete**
3. All plugin settings will be automatically removed
4. Your WooCommerce products and settings remain untouched

### File Structure

```
digital-rise-whatsapp-solutions/
├── assets/
│   └── index.php
├── includes/
│   ├── class-drws-admin-settings.php
│   ├── class-drws-frontend.php
│   ├── drws-functions.php
│   └── index.php
├── languages/
│   ├── digital-rise-whatsapp-solutions.pot
│   └── index.php
├── digital-rise-whatsapp-solutions.php (main plugin file)
├── index.php
├── readme.txt
├── uninstall.php
└── INSTALLATION.md (this file)
```

### Developer Information

#### Hooks Available

The plugin provides several hooks for developers:

**Actions:**
- `drws_before_whatsapp_button` - Before button render
- `drws_after_whatsapp_button` - After button render

**Filters:**
- `drws_whatsapp_url` - Modify WhatsApp URL
- `drws_button_text` - Modify button text
- `drws_button_class` - Modify button CSS class

#### Helper Functions

```php
// Get WhatsApp number
$number = drws_get_whatsapp_number();

// Get message template
$message = drws_get_whatsapp_message();

// Get WhatsApp URL for a product
$url = drws_get_product_whatsapp_url( $product_id );

// Check if configured
if ( drws_is_configured() ) {
    // WhatsApp is set up
}

// Display custom button
drws_display_whatsapp_button( $product_id, array(
    'class' => 'custom-class',
    'text' => 'Custom Text',
    'show_icon' => true,
    'new_window' => true
) );
```

### Support

For support, feature requests, or bug reports:
- Website: https://digital-rise-solutions.com/
- Author: Oussama Ben Rejab
- Email: Contact via website

### License

This plugin is licensed under GPL v2 or later.
License URI: https://www.gnu.org/licenses/gpl-2.0.html

### Credits

Developed by Oussama Ben Rejab
Digital Rise Solutions
https://digital-rise-solutions.com/

---

**Thank you for using Digital Rise WhatsApp Solutions!**
