<?php
/**
 * Uninstall Digital Rise SEO Solutions
 *
 * @package Digital_Rise_SEO_Solutions
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Delete all plugin options
delete_option( 'drss_options' );
delete_option( 'drss_audit_results' );
delete_option( 'drss_audit_site_checks' );
delete_option( 'drss_audit_last_scan' );
delete_option( 'drss_checklist_progress' );
delete_option( 'drss_pending_reviews' );
delete_option( 'drss_upgrade_dismissed' );

// Delete transients
delete_transient( 'drss_activation_redirect' );
delete_transient( 'drss_initial_checkin_done' );
delete_transient( 'drss_auto_sync' );

// Clear scheduled hooks
wp_clear_scheduled_hook( 'drss_remote_checkin' );
wp_clear_scheduled_hook( 'drss_license_check' );
wp_clear_scheduled_hook( 'drss_cleanup_logs' );

// Clean up post meta
global $wpdb;
$wpdb->query( "DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '_drss_%'" );

// Drop custom tables if they exist
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}drss_optimization_log" );

// Clean cache directory
$cache_dir = WP_CONTENT_DIR . '/cache/drss-minify/';
if ( is_dir( $cache_dir ) ) {
    array_map( 'unlink', glob( $cache_dir . '*' ) );
    rmdir( $cache_dir );
}
