<?php
/**
 * Public functionality
 *
 * @package Digital_Rise_SEO_Solutions
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class DRSS_Public {

    private $plugin;

    public function __construct( $plugin ) {
        $this->plugin = $plugin;
    }

    public function enqueue_styles() {
        if ( $this->plugin->get_option( 'show_attribution', true ) && $this->plugin->current_plan === 'free' ) {
            wp_enqueue_style( 'drss-public', DRSS_PLUGIN_URL . 'public/css/drss-public.css', array(), DRSS_VERSION );
        }
    }

    public function output_attribution() {
        if ( ! $this->plugin->get_option( 'show_attribution', true ) ) {
            return;
        }
        if ( $this->plugin->current_plan !== 'free' && ! $this->plugin->get_option( 'show_attribution', false ) ) {
            return;
        }
        ?>
        <div class="drss-attribution">
            <a href="https://digital-rise-solutions.com/" target="_blank" rel="noopener">
                <?php esc_html_e( 'Powered by Digital Rise Solutions', 'digital-rise-seo-solutions' ); ?>
            </a>
        </div>
        <?php
    }
}
