<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" 
    xmlns:html="http://www.w3.org/1999/xhtml"
    xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
    xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  
  <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
  
  <xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <title>XML Sitemap</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
        <style type="text/css">
          body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
            font-size: 14px;
            color: #333;
            margin: 0;
            padding: 0;
            background: #f5f5f5;
          }
          .header {
            background: linear-gradient(135deg, #1e3a5f 0%, #2c5282 100%);
            color: white;
            padding: 30px 20px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
          }
          .header-content {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 20px;
          }
          .logo {
            width: 60px;
            height: 60px;
            background: white;
            border-radius: 10px;
            padding: 10px;
          }
          .header h1 {
            margin: 0 0 10px 0;
            font-size: 28px;
            font-weight: 600;
          }
          .header p {
            margin: 0;
            font-size: 16px;
            opacity: 0.9;
          }
          .header a {
            color: #ffd700;
            text-decoration: none;
            font-weight: 600;
          }
          .header a:hover {
            text-decoration: underline;
          }
          .container {
            max-width: 1200px;
            margin: 30px auto;
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            overflow: hidden;
          }
          .stats {
            background: #f8f9fa;
            padding: 20px;
            border-bottom: 1px solid #e0e0e0;
            display: flex;
            justify-content: space-around;
            flex-wrap: wrap;
          }
          .stat-item {
            text-align: center;
            padding: 10px 20px;
          }
          .stat-number {
            font-size: 32px;
            font-weight: bold;
            color: #2c5282;
          }
          .stat-label {
            font-size: 14px;
            color: #666;
            margin-top: 5px;
          }
          table {
            width: 100%;
            border-collapse: collapse;
          }
          th {
            background: #2c5282;
            color: white;
            padding: 12px 15px;
            text-align: left;
            font-weight: 600;
            font-size: 13px;
            text-transform: uppercase;
          }
          td {
            padding: 12px 15px;
            border-bottom: 1px solid #e0e0e0;
          }
          tr:hover {
            background: #f8f9fa;
          }
          .url {
            color: #2c5282;
            text-decoration: none;
            word-break: break-all;
          }
          .url:hover {
            text-decoration: underline;
          }
          .priority {
            text-align: center;
            font-weight: 600;
          }
          .priority-high { color: #4CAF50; }
          .priority-medium { color: #FF9800; }
          .priority-low { color: #9E9E9E; }
          .changefreq {
            text-align: center;
            font-size: 12px;
            color: #666;
          }
          .lastmod {
            text-align: center;
            font-size: 12px;
            color: #666;
          }
          .footer {
            text-align: center;
            padding: 20px;
            color: #666;
            font-size: 12px;
          }
          .nav-buttons {
            text-align: center;
            margin: 20px 0;
          }
          .nav-buttons a {
            display: inline-block;
            padding: 12px 24px;
            margin: 0 10px;
            background: #2c5282;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            transition: all 0.3s;
          }
          .nav-buttons a:hover {
            background: #1e3a5f;
            transform: translateY(-2px);
          }
          .nav-buttons .back-btn {
            background: #ffd700;
            color: #333;
          }
          .nav-buttons .back-btn:hover {
            background: #ffed4e;
          }
        </style>
      </head>
      <body>
        <div class="header">
          <div class="header-content">
            <div>
              <h1>🗺️ XML Sitemap</h1>
              <p>This sitemap is generated by <strong>WP SEO Plugin</strong> from <a href="https://digital-rise-solutions.com" target="_blank">Digital Rise Solutions</a></p>
            </div>
          </div>
        </div>
        
        <div class="nav-buttons">
          <a href="/sitemap.xml" class="back-btn" target="_blank">← Back to Sitemap Index</a>
        </div>
        
        <div class="container">
          <div class="stats">
            <div class="stat-item">
              <div class="stat-number"><xsl:value-of select="count(sitemap:urlset/sitemap:url)"/></div>
              <div class="stat-label">Total URLs</div>
            </div>
            <div class="stat-item">
              <div class="stat-number"><xsl:value-of select="count(sitemap:urlset/sitemap:url[sitemap:priority &gt; 0.7])"/></div>
              <div class="stat-label">High Priority</div>
            </div>
            <div class="stat-item">
              <div class="stat-number"><xsl:value-of select="count(sitemap:urlset/sitemap:url/image:image)"/></div>
              <div class="stat-label">Images</div>
            </div>
          </div>
          
          <table>
            <thead>
              <tr>
                <th style="width: 50%;">URL</th>
                <th style="width: 15%;">Priority</th>
                <th style="width: 15%;">Change Freq</th>
                <th style="width: 20%;">Last Modified</th>
              </tr>
            </thead>
            <tbody>
              <xsl:for-each select="sitemap:urlset/sitemap:url">
                <tr>
                  <td>
                    <a class="url" href="{sitemap:loc}" target="_blank">
                      <xsl:value-of select="sitemap:loc"/>
                    </a>
                  </td>
                  <td class="priority">
                    <xsl:variable name="priority" select="sitemap:priority"/>
                    <span>
                      <xsl:attribute name="class">
                        <xsl:choose>
                          <xsl:when test="$priority &gt; 0.7">priority-high</xsl:when>
                          <xsl:when test="$priority &gt; 0.4">priority-medium</xsl:when>
                          <xsl:otherwise>priority-low</xsl:otherwise>
                        </xsl:choose>
                      </xsl:attribute>
                      <xsl:value-of select="sitemap:priority"/>
                    </span>
                  </td>
                  <td class="changefreq">
                    <xsl:value-of select="sitemap:changefreq"/>
                  </td>
                  <td class="lastmod">
                    <xsl:value-of select="substring(sitemap:lastmod, 1, 10)"/>
                  </td>
                </tr>
              </xsl:for-each>
            </tbody>
          </table>
          
          <div class="footer">
            Powered by <strong>Image Optimizer for SEO</strong> | 
            <a href="https://digital-rise-solutions.com" target="_blank">Digital Rise Solutions</a>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
