<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9">
  
  <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
  
  <xsl:template match="/">
    <html>
      <head>
        <title>Sitemap Index</title>
        <style>
          body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
          .header { background: linear-gradient(135deg, #1e3a5f 0%, #2c5282 100%); color: white; padding: 30px; text-align: center; border-radius: 8px; margin-bottom: 20px; }
          .nav-buttons { text-align: center; margin-bottom: 20px; }
          .nav-buttons a { display: inline-block; padding: 12px 24px; margin: 0 10px; background: #2c5282; color: white; text-decoration: none; border-radius: 6px; font-weight: 600; transition: all 0.3s; }
          .nav-buttons a:hover { background: #1e3a5f; transform: translateY(-2px); }
          .nav-buttons .home-btn { background: #ffd700; color: #333; }
          .nav-buttons .home-btn:hover { background: #ffed4e; }
          .container { max-width: 1000px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
          table { width: 100%; border-collapse: collapse; }
          th { background: #2c5282; color: white; padding: 12px; text-align: left; }
          td { padding: 12px; border-bottom: 1px solid #e0e0e0; }
          a { color: #2c5282; text-decoration: none; }
          a:hover { text-decoration: underline; }
        </style>
      </head>
      <body>
        <div class="header">
          <h1>🗂️ Sitemap Index</h1>
          <p>Generated by WP SEO Plugin from <a href="https://digital-rise-solutions.com" style="color: #ffd700;" target="_blank">Digital Rise Solutions</a></p>
        </div>
        
        <div class="nav-buttons">
          <a href="/" class="home-btn" target="_blank">🏠 Go to Homepage</a>
        </div>
        
        <div class="container">
          <table>
            <thead>
              <tr>
                <th>Sitemap</th>
                <th>Last Modified</th>
              </tr>
            </thead>
            <tbody>
              <xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
                <tr>
                  <td><a href="{sitemap:loc}" target="_blank"><xsl:value-of select="sitemap:loc"/></a></td>
                  <td><xsl:value-of select="substring(sitemap:lastmod, 1, 10)"/></td>
                </tr>
              </xsl:for-each>
            </tbody>
          </table>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
