/* Digital Rise Image Optimizer Pro - Admin JS */
(function($) {
    'use strict';

    $(document).ready(function() {
        // Range sliders
        $('#compression_quality').on('input', function() {
            $('#quality_value').text($(this).val() + '%');
        });

        // License activation
        $('#activate-license').on('click', function() {
            var key = $('#license_key').val();
            if (!key) {
                alert('Please enter a license key');
                return;
            }

            var $btn = $(this);
            $btn.prop('disabled', true).text(drss_admin.strings.optimizing);

            $.ajax({
                url: drss_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'drss_activate_license',
                    license_key: key,
                    nonce: drss_admin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $('#license-message').html('<div class="notice notice-success"><p>' + response.data.message + '</p></div>');
                        setTimeout(function() { location.reload(); }, 1500);
                    } else {
                        $('#license-message').html('<div class="notice notice-error"><p>' + response.data + '</p></div>');
                    }
                },
                error: function() {
                    $('#license-message').html('<div class="notice notice-error"><p>Error occurred</p></div>');
                },
                complete: function() {
                    $btn.prop('disabled', false).text('Activate License');
                }
            });
        });

        // License deactivation
        $('#deactivate-license').on('click', function() {
            if (!confirm('Are you sure you want to deactivate your license?')) return;

            $.ajax({
                url: drss_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'drss_deactivate_license',
                    nonce: drss_admin.nonce
                },
                success: function() {
                    location.reload();
                }
            });
        });

        // Bulk optimization
        var bulkRunning = false;

        $('#start-bulk-optimize').on('click', function() {
            bulkRunning = true;
            $(this).hide();
            $('#stop-bulk-optimize').show();
            $('#bulk-log').show().html('');
            $('#reset-optimization').prop('disabled', true);
            runBulkOptimize();
        });

        $('#stop-bulk-optimize').on('click', function() {
            bulkRunning = false;
            $(this).hide();
            $('#start-bulk-optimize').show();
            $('#reset-optimization').prop('disabled', false);
            logMessage('Stopped by user', 'info');
        });
        
        // Reset optimization
        $('#reset-optimization').on('click', function() {
            if (!confirm('This will mark all images as unoptimized. Are you sure?')) return;
            
            var $btn = $(this);
            $btn.prop('disabled', true);
            
            $.ajax({
                url: drss_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'drss_reset_optimization',
                    nonce: drss_admin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.data.message);
                        location.reload();
                    }
                },
                complete: function() {
                    $btn.prop('disabled', false);
                }
            });
        });

        function runBulkOptimize() {
            if (!bulkRunning) return;

            var applySeo = $('#apply_seo').is(':checked');
            var reoptimize = $('#reoptimize_all').is(':checked');

            $.ajax({
                url: drss_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'drss_bulk_optimize',
                    apply_seo: applySeo,
                    reoptimize: reoptimize,
                    nonce: drss_admin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        var data = response.data;
                        
                        // Update progress
                        updateProgress();
                        
                        // Log results
                        if (data.details) {
                            data.details.forEach(function(item) {
                                var msg = item.title + ' - ' + (item.status === 'success' ? 'Saved ' + item.savings + '%' : item.message);
                                logMessage(msg, item.status);
                            });
                        }

                        if (data.completed) {
                            bulkRunning = false;
                            $('#stop-bulk-optimize').hide();
                            $('#start-bulk-optimize').show().prop('disabled', false).text('Optimization Complete - Click to Run Again');
                            $('#reset-optimization').prop('disabled', false);
                            logMessage('All images processed!', 'success');
                        } else {
                            setTimeout(runBulkOptimize, 500);
                        }
                    }
                },
                error: function() {
                    logMessage('Error occurred, retrying...', 'error');
                    setTimeout(runBulkOptimize, 2000);
                }
            });
        }

        function updateProgress() {
            $.ajax({
                url: drss_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'drss_get_optimization_progress',
                    nonce: drss_admin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        var data = response.data;
                        $('#bulk-progress-fill').css('width', data.percentage + '%');
                        $('#bulk-progress-text').text(data.optimized + ' of ' + data.total + ' images optimized (' + data.remaining + ' remaining)');
                    }
                }
            });
        }

        function logMessage(msg, type) {
            var $log = $('#bulk-log');
            var time = new Date().toLocaleTimeString();
            $log.append('<div class="' + type + '">[' + time + '] ' + msg + '</div>');
            $log.scrollTop($log[0].scrollHeight);
        }

        // Dismiss notices
        $(document).on('click', '.drss-upgrade-banner .notice-dismiss', function() {
            $.post(drss_admin.ajax_url, {
                action: 'drss_dismiss_notice',
                notice: 'upgrade_banner',
                nonce: drss_admin.nonce
            });
        });

        $(document).on('click', '.drss-remote-notice .notice-dismiss', function() {
            var noticeId = $(this).closest('.drss-remote-notice').data('notice-id');
            $.post(drss_admin.ajax_url, {
                action: 'drss_dismiss_notice',
                notice: noticeId,
                nonce: drss_admin.nonce
            });
        });

        // Sync notices button
        $('#sync-notices').on('click', function() {
            var $btn = $(this);
            $btn.prop('disabled', true).text('Syncing...');
            
            $.ajax({
                url: drss_admin.ajax_url,
                type: 'POST',
                data: {
                    action: 'drss_sync_notices',
                    nonce: drss_admin.nonce
                },
                success: function(response) {
                    if (response.success) {
                        alert(response.data.message + ' (' + response.data.count + ' active notices)');
                        location.reload();
                    } else {
                        alert('Sync failed. Please try again.');
                    }
                },
                error: function() {
                    alert('Connection error. Please check your internet connection.');
                },
                complete: function() {
                    $btn.prop('disabled', false).text('Sync Notices');
                }
            });
        });
    });
})(jQuery);
