<?php
/**
 * Class DRPS_Frontend
 * Enqueues frontend CSS and JS, and passes the current page's
 * resolved settings (global vs. meta-box override) to JavaScript.
 *
 * @package DigitalRisePostsSolutions
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class DRPS_Frontend {

    public function __construct() {
        // Enqueue on every frontend page (lightweight; JS only runs when shortcode is present)
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_frontend_assets' ) );
    }

    /**
     * Enqueue CSS + JS on the frontend.
     * We also localize the current page's effective settings so the JS
     * carousel/grid can initialize correctly without a separate AJAX call.
     */
    public function enqueue_frontend_assets() {
        wp_enqueue_style(
            'drps-frontend-css',
            DRPS_PLUGIN_URL . 'assets/css/frontend.css',
            array(),
            DRPS_VERSION
        );

        wp_enqueue_script(
            'drps-frontend-js',
            DRPS_PLUGIN_URL . 'assets/js/frontend.js',
            array(), // no jQuery dependency — vanilla JS only
            DRPS_VERSION,
            true // footer
        );

        // Resolve settings for the current post/page (meta overrides global)
        $settings = DRPS_Shortcode::resolve_settings( get_the_ID() );

        wp_localize_script(
            'drps-frontend-js',
            'drps_settings',
            array(
                'layout'         => esc_attr( $settings['layout'] ),
                'loop'           => $settings['loop'] ? '1' : '0',
                'autoplay_speed' => absint( $settings['autoplay_speed'] ),
                'posts_per_view' => absint( $settings['posts_per_view'] ),
            )
        );
    }
}
