<?php
/**
 * Plugin Name: Digital Rise Posts Solutions
 * Plugin URI:  https://digital-rise-solutions.com
 * Description: Display WordPress posts in a responsive carousel or grid layout with full admin customization, per-page/post overrides, and live preview.
 * Version:     1.0.0
 * Author:      Oussama Ben Rejab / Digital Rise Solutions
 * Author URI:  https://digital-rise-solutions.com
 * License:     GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: digital-rise-posts-solutions
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP:      7.2
 *
 * @package DigitalRisePostsSolutions
 */

// Exit if accessed directly — security best practice
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// ── Plugin Constants ────────────────────────────────────────────────────────
define( 'DRPS_VERSION',      '1.0.0' );
define( 'DRPS_PLUGIN_DIR',   plugin_dir_path( __FILE__ ) );
define( 'DRPS_PLUGIN_URL',   plugin_dir_url( __FILE__ ) );
define( 'DRPS_TEXT_DOMAIN',  'digital-rise-posts-solutions' );
define( 'DRPS_DONATE_URL',   'https://digital-rise-solutions.com/pay-easily-with-usdt-trc20-using-redotpay/' );

/**
 * Load plugin text domain for i18n / translations.
 */
function drps_load_textdomain() {
    load_plugin_textdomain(
        DRPS_TEXT_DOMAIN,
        false,
        dirname( plugin_basename( __FILE__ ) ) . '/languages'
    );
}
add_action( 'plugins_loaded', 'drps_load_textdomain' );

// ── Include sub-modules ─────────────────────────────────────────────────────
require_once DRPS_PLUGIN_DIR . 'includes/class-drps-admin.php';
require_once DRPS_PLUGIN_DIR . 'includes/class-drps-frontend.php';
require_once DRPS_PLUGIN_DIR . 'includes/class-drps-metabox.php';
require_once DRPS_PLUGIN_DIR . 'includes/class-drps-ajax.php';
require_once DRPS_PLUGIN_DIR . 'includes/class-drps-shortcode.php';

// ── Instantiate classes ─────────────────────────────────────────────────────
new DRPS_Admin();
new DRPS_Frontend();
new DRPS_Metabox();
new DRPS_Ajax();
new DRPS_Shortcode();

// ── Activation Hook ─────────────────────────────────────────────────────────
register_activation_hook( __FILE__, 'drps_activate' );

/**
 * On activation: seed default options so the plugin works out of the box.
 */
function drps_activate() {
    $defaults = array(
        'drps_layout'          => 'carousel',
        'drps_loop'            => '1',
        'drps_autoplay_speed'  => '2000',
        'drps_posts_per_view'  => '3',
        'drps_include_cats'    => '',
        'drps_exclude_cats'    => '',
        'drps_include_tags'    => '',
        'drps_exclude_tags'    => '',
        'drps_activated'       => '1', // flag: show instructions once
    );
    foreach ( $defaults as $key => $value ) {
        if ( ! get_option( $key ) ) {
            update_option( $key, $value );
        }
    }
    // Flush rewrite rules just in case
    flush_rewrite_rules();
}

// ── Deactivation Hook ───────────────────────────────────────────────────────
register_deactivation_hook( __FILE__, 'drps_deactivate' );

function drps_deactivate() {
    flush_rewrite_rules();
}

// ── Donate link in Plugins page (beside Deactivate) ─────────────────────────
function drps_plugin_actions( $links ) {
    $donate = '<a href="' . esc_url( DRPS_DONATE_URL ) . '" target="_blank" style="color:#e67e22;font-weight:600;" class="drps-donate-link">'
            . esc_html__( '💛 Donate', DRPS_TEXT_DOMAIN ) . '</a>';
    $links[] = $donate;
    return $links;
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'drps_plugin_actions' );
