<?php
/**
 * WooCommerce Integration
 *
 * @package Digital_Rise_Image_Optimizer_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class DRIOP_WooCommerce {

    private $plugin;

    public function __construct( $plugin ) {
        $this->plugin = $plugin;
    }

    public function is_active() {
        return class_exists( 'WooCommerce' );
    }

    public function add_product_seo_meta_box() {
        if ( ! $this->is_active() ) return;

        add_meta_box(
            'driop_product_image_info',
            __( 'Digital Rise Image Info', 'digital-rise-image-optimizer-for-seo' ),
            array( $this, 'render_product_meta_box' ),
            'product',
            'side',
            'low'
        );
    }

    public function render_product_meta_box( $post ) {
        $product = wc_get_product( $post->ID );
        if ( ! $product ) {
            echo '<p>' . esc_html__( 'Product not found.', 'digital-rise-image-optimizer-for-seo' ) . '</p>';
            return;
        }

        $image_count = $this->get_product_image_count( $post->ID );
        $max_images = $this->plugin->get_option( 'max_images_per_product', 10 );
        $has_limit = $this->plugin->has_feature( 'per_product_limits' );
        ?>
        <p><strong><?php esc_html_e( 'Images:', 'digital-rise-image-optimizer-for-seo' ); ?></strong> 
            <?php echo esc_html( $image_count ); ?>
            <?php if ( $has_limit && $max_images > 0 ) echo '/ ' . esc_html( $max_images ); ?>
        </p>
        <?php if ( $has_limit && $max_images > 0 && $image_count >= $max_images ) : ?>
            <p style="color: #dc3545;"><?php esc_html_e( 'Limit reached!', 'digital-rise-image-optimizer-for-seo' ); ?></p>
        <?php endif;
    }

    public function get_product_image_count( $product_id ) {
        $product = wc_get_product( $product_id );
        if ( ! $product ) return 0;

        $count = $product->get_image_id() ? 1 : 0;
        $count += count( $product->get_gallery_image_ids() );
        return $count;
    }

    public function get_stats() {
        if ( ! $this->is_active() ) {
            return array( 'active' => false );
        }

        return array(
            'active' => true,
            'version' => defined( 'WC_VERSION' ) ? WC_VERSION : 'Unknown',
            'total_products' => (int) wp_count_posts( 'product' )->publish,
        );
    }
}
