<?php
/**
 * Plugin Deactivator
 *
 * @package Digital_Rise_Image_Optimizer_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class DRIOP_Deactivator {

    public static function deactivate() {
        // Clear scheduled hooks
        wp_clear_scheduled_hook( 'driop_remote_checkin' );
        wp_clear_scheduled_hook( 'driop_license_check' );
        wp_clear_scheduled_hook( 'driop_cleanup_logs' );
        
        // Notify owner server of deactivation
        self::notify_owner_deactivation( 'deactivated' );
    }
    
    /**
     * Notify owner server when plugin is deactivated
     */
    public static function notify_owner_deactivation( $action = 'deactivated' ) {
        $options = get_option( 'driop_options', array() );
        
        // Check if remote connection is enabled
        if ( empty( $options['remote_connection'] ) ) {
            return;
        }
        
        $installation_id = isset( $options['installation_id'] ) ? $options['installation_id'] : '';
        
        if ( empty( $installation_id ) ) {
            return;
        }
        
        $api_url = defined( 'DRIOP_OWNER_API' ) ? DRIOP_OWNER_API : '';
        
        if ( empty( $api_url ) ) {
            return;
        }
        
        // Send deactivation notice (non-blocking)
        wp_remote_post( $api_url . 'plugin-deactivated', array(
            'timeout' => 5,
            'blocking' => false,
            'headers' => array( 'Content-Type' => 'application/json' ),
            'body' => wp_json_encode( array(
                'installation_id' => $installation_id,
                'site_url' => home_url(),
                'action' => $action,
            )),
        ));
    }
}
