<?php
/**
 * Digital Rise Head and Footer Solutions — Uninstall
 *
 * Fired when the plugin is deleted via the WordPress admin.
 * Removes ALL plugin data from the database.
 *
 * @package DigitalRiseHeadFooter
 */

// Abort if not called by WordPress uninstall process.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

/**
 * Remove all plugin options from a single site.
 *
 * @return void
 */
function drhf_delete_site_options() {
    delete_option( 'digital_rise_header_snippets' );
    delete_option( 'digital_rise_body_snippets' );
    delete_option( 'digital_rise_footer_snippets' );
    delete_option( 'drhf_db_version' );
}

// Single site.
drhf_delete_site_options();

// Multisite: clean every site.
if ( is_multisite() ) {
    $sites = get_sites( array( 'fields' => 'ids', 'number' => 0 ) );
    foreach ( $sites as $site_id ) {
        switch_to_blog( $site_id );
        drhf_delete_site_options();
        restore_current_blog();
    }
}
