<?php
/**
 * Plans Management
 *
 * @package Digital_Rise_Image_Optimizer_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class DRIOP_Plans {

    private $plugin;
    private $features = array();

    public function __construct( $plugin ) {
        $this->plugin = $plugin;
        $this->define_features();
    }

    private function define_features() {
        $this->features = array(
            'free' => array(
                'image_compression' => true,
                'auto_resize' => true,
                'basic_watermark' => true,
                'basic_rename' => true,
                'auto_alt' => true,
                'wc_basic' => true,
                'bulk_optimize' => true,
                // Restricted
                'custom_keywords' => false,
                'custom_watermark' => false,
                'watermark_size_control' => false,
                'per_user_limits' => false,
                'per_product_limits' => false,
                'per_vendor_limits' => false,
                'advanced_seo' => false,
                'priority_support' => false,
                'unlimited_sites' => false,
                'white_label' => false,
                'disable_attribution' => false,
            ),
            'pro' => array(
                'image_compression' => true,
                'auto_resize' => true,
                'basic_watermark' => true,
                'basic_rename' => true,
                'auto_alt' => true,
                'wc_basic' => true,
                'bulk_optimize' => true,
                'custom_keywords' => true,
                'custom_watermark' => true,
                'watermark_size_control' => true,
                'per_user_limits' => true,
                'per_product_limits' => true,
                'advanced_seo' => true,
                'priority_support' => true,
                'disable_attribution' => true,
                // Restricted
                'per_vendor_limits' => false,
                'unlimited_sites' => false,
                'white_label' => false,
            ),
            'agency' => array(
                'image_compression' => true,
                'auto_resize' => true,
                'basic_watermark' => true,
                'basic_rename' => true,
                'auto_alt' => true,
                'wc_basic' => true,
                'bulk_optimize' => true,
                'custom_keywords' => true,
                'custom_watermark' => true,
                'watermark_size_control' => true,
                'per_user_limits' => true,
                'per_product_limits' => true,
                'per_vendor_limits' => true,
                'advanced_seo' => true,
                'priority_support' => true,
                'unlimited_sites' => true,
                'white_label' => true,
                'disable_attribution' => true,
            ),
        );
    }

    public function has_feature( $feature ) {
        $plan = $this->plugin->current_plan;
        if ( ! isset( $this->features[ $plan ] ) ) {
            $plan = 'free';
        }
        return isset( $this->features[ $plan ][ $feature ] ) && $this->features[ $plan ][ $feature ];
    }

    public function get_plans() {
        return array(
            'free' => array(
                'name' => __( 'Free', 'digital-rise-solutions' ),
                'price' => __( 'Free Forever', 'digital-rise-solutions' ),
                'description' => __( 'Basic image optimization', 'digital-rise-solutions' ),
                'features' => array(
                    __( 'Compress images to 50KB', 'digital-rise-solutions' ),
                    __( 'Auto resize images', 'digital-rise-solutions' ),
                    __( 'Site-name watermark', 'digital-rise-solutions' ),
                    __( 'Basic image rename', 'digital-rise-solutions' ),
                    __( 'Auto ALT text', 'digital-rise-solutions' ),
                    __( 'Bulk optimization', 'digital-rise-solutions' ),
                ),
                'limitations' => array(
                    __( 'Attribution link required', 'digital-rise-solutions' ),
                    __( 'No custom keywords', 'digital-rise-solutions' ),
                    __( 'No custom watermark', 'digital-rise-solutions' ),
                ),
            ),
            'pro' => array(
                'name' => __( 'Pro', 'digital-rise-solutions' ),
                'price' => __( 'Contact for pricing', 'digital-rise-solutions' ),
                'description' => __( 'Advanced features for businesses', 'digital-rise-solutions' ),
                'features' => array(
                    __( 'Everything in Free', 'digital-rise-solutions' ),
                    __( 'Custom keywords system', 'digital-rise-solutions' ),
                    __( 'Custom watermark text', 'digital-rise-solutions' ),
                    __( 'Watermark size control', 'digital-rise-solutions' ),
                    __( 'Per-user image limits', 'digital-rise-solutions' ),
                    __( 'Per-product image limits', 'digital-rise-solutions' ),
                    __( 'Advanced image SEO', 'digital-rise-solutions' ),
                    __( 'Priority email support', 'digital-rise-solutions' ),
                    __( 'Remove attribution', 'digital-rise-solutions' ),
                ),
            ),
            'agency' => array(
                'name' => __( 'Agency', 'digital-rise-solutions' ),
                'price' => __( 'Contact for pricing', 'digital-rise-solutions' ),
                'description' => __( 'Complete solution for agencies', 'digital-rise-solutions' ),
                'features' => array(
                    __( 'Everything in Pro', 'digital-rise-solutions' ),
                    __( 'Multi-site license', 'digital-rise-solutions' ),
                    __( 'Per-vendor limits (Dokan)', 'digital-rise-solutions' ),
                    __( 'White-label watermark', 'digital-rise-solutions' ),
                    __( 'Full owner control', 'digital-rise-solutions' ),
                    __( 'Priority support', 'digital-rise-solutions' ),
                ),
            ),
        );
    }

    public function get_current_plan_name() {
        $plans = $this->get_plans();
        $current = $this->plugin->current_plan;
        return isset( $plans[ $current ]['name'] ) ? $plans[ $current ]['name'] : __( 'Free', 'digital-rise-solutions' );
    }
}
