<?php
/**
 * Dokan Integration
 *
 * @package Digital_Rise_Image_Optimizer_Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class DRIOP_Dokan {

    private $plugin;

    public function __construct( $plugin ) {
        $this->plugin = $plugin;
    }

    public function is_active() {
        return class_exists( 'WeDevs_Dokan' ) || function_exists( 'dokan' );
    }

    public function check_vendor_image_limit( $upload, $vendor_id = 0 ) {
        if ( ! $this->plugin->has_feature( 'per_vendor_limits' ) ) {
            return $upload;
        }

        if ( ! $vendor_id ) {
            $vendor_id = get_current_user_id();
        }

        if ( ! $this->is_vendor( $vendor_id ) ) {
            return $upload;
        }

        $max_per_vendor = $this->plugin->get_option( 'max_images_per_vendor', 50 );
        if ( $max_per_vendor <= 0 ) {
            return $upload;
        }

        $current_count = $this->get_vendor_image_count( $vendor_id );

        if ( $current_count >= $max_per_vendor ) {
            return array(
                'error' => sprintf(
                    __( 'You have reached your vendor image limit of %d images.', 'digital-rise-solutions' ),
                    $max_per_vendor
                ),
            );
        }

        return $upload;
    }

    public function is_vendor( $user_id ) {
        if ( function_exists( 'dokan_is_user_seller' ) ) {
            return dokan_is_user_seller( $user_id );
        }
        $user = get_user_by( 'id', $user_id );
        if ( ! $user ) return false;
        return in_array( 'seller', (array) $user->roles, true ) || in_array( 'vendor', (array) $user->roles, true );
    }

    public function get_vendor_image_count( $vendor_id ) {
        global $wpdb;
        return (int) $wpdb->get_var( $wpdb->prepare(
            "SELECT COUNT(*) FROM {$wpdb->posts} WHERE post_type = 'attachment' AND post_mime_type LIKE 'image/%%' AND post_author = %d",
            $vendor_id
        ) );
    }

    public function get_stats() {
        if ( ! $this->is_active() ) {
            return array( 'active' => false );
        }

        global $wpdb;
        $vendors = $wpdb->get_var(
            "SELECT COUNT(*) FROM {$wpdb->usermeta} WHERE meta_key = 'dokan_enable_selling' AND meta_value = 'yes'"
        );

        return array(
            'active' => true,
            'total_vendors' => (int) $vendors,
        );
    }
}
