<?php
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) exit;

// Get options before deleting
$driop_options = get_option( 'driop_options', array() );
$driop_installation_id = isset( $driop_options['installation_id'] ) ? $driop_options['installation_id'] : '';

// Notify owner server of uninstall
if ( ! empty( $driop_installation_id ) && ! empty( $driop_options['remote_connection'] ) ) {
    $driop_api_url = 'https://digital-rise-solutions.com/wp-json/driop-license/v1/';
    
    wp_remote_post( $driop_api_url . 'plugin-deactivated', array(
        'timeout' => 5,
        'blocking' => false,
        'headers' => array( 'Content-Type' => 'application/json' ),
        'body' => wp_json_encode( array(
            'installation_id' => $driop_installation_id,
            'site_url' => home_url(),
            'action' => 'uninstalled',
        )),
    ));
}

// Clean up options
delete_option( 'driop_options' );
delete_option( 'driop_db_version' );
delete_option( 'driop_upgrade_dismissed' );

// Clean up database tables
global $wpdb;
// phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange -- Cleanup on uninstall
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}driop_optimization_log" );
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}driop_user_image_count" );
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}driop_remote_notices" );
$wpdb->query( "DROP TABLE IF EXISTS {$wpdb->prefix}driop_keywords" );
$wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE %s", '_driop_%' ) );
// phpcs:enable

// Clear scheduled hooks
wp_clear_scheduled_hook( 'driop_remote_checkin' );
wp_clear_scheduled_hook( 'driop_license_check' );
