<?php
/**
 * Logs View
 * 
 * @package Digital_Rise_Auto_Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Get imported posts for selected campaign to show image debug info
$imported_posts = array();
if ( $campaign_id ) {
    $imported_posts = get_posts( array(
        'post_type' => 'post',
        'posts_per_page' => 20,
        'meta_key' => '_drap_campaign_id',
        'meta_value' => $campaign_id,
        'orderby' => 'date',
        'order' => 'DESC',
    ) );
}
?>
<div class="wrap drap-wrap">
    <h1><?php _e( 'Campaign Logs', 'digital-rise-auto-poster' ); ?></h1>
    <hr class="wp-header-end">

    <div class="drap-logs-filter">
        <form method="get">
            <input type="hidden" name="page" value="drap-logs">
            <label><?php _e( 'Campaign:', 'digital-rise-auto-poster' ); ?></label>
            <select name="campaign_id">
                <option value=""><?php _e( 'Select...', 'digital-rise-auto-poster' ); ?></option>
                <?php foreach ( $campaigns as $c ) : ?>
                    <option value="<?php echo $c->id; ?>" <?php selected( $campaign_id, $c->id ); ?>>
                        <?php echo esc_html( $c->title ); ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button type="submit" class="button"><?php _e( 'Filter', 'digital-rise-auto-poster' ); ?></button>
        </form>
    </div>

    <?php if ( $campaign_id && ! empty( $imported_posts ) ) : ?>
        <!-- Image Debug Section -->
        <div class="drap-box" style="margin-bottom: 20px;">
            <h2 style="background: #fff3cd; color: #856404;"><?php _e( '🔍 Image Debug - Recent Imported Posts', 'digital-rise-auto-poster' ); ?></h2>
            <table class="wp-list-table widefat fixed striped" style="margin: 0;">
                <thead>
                    <tr>
                        <th style="width: 30%;"><?php _e( 'Post Title', 'digital-rise-auto-poster' ); ?></th>
                        <th style="width: 50%;"><?php _e( 'Source Image URL', 'digital-rise-auto-poster' ); ?></th>
                        <th style="width: 20%;"><?php _e( 'Thumbnail', 'digital-rise-auto-poster' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ( $imported_posts as $post ) : 
                        $image_url = get_post_meta( $post->ID, '_drap_source_image', true );
                        $thumb_id = get_post_thumbnail_id( $post->ID );
                        $thumb_url = $thumb_id ? wp_get_attachment_image_url( $thumb_id, 'thumbnail' ) : '';
                    ?>
                        <tr>
                            <td>
                                <a href="<?php echo get_edit_post_link( $post->ID ); ?>" target="_blank">
                                    <?php echo esc_html( $post->post_title ); ?>
                                </a>
                            </td>
                            <td>
                                <?php if ( $image_url ) : ?>
                                    <code style="font-size: 11px; word-break: break-all;"><?php echo esc_html( $image_url ); ?></code>
                                <?php else : ?>
                                    <em style="color: #999;"><?php _e( 'No image URL stored', 'digital-rise-auto-poster' ); ?></em>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if ( $thumb_url ) : ?>
                                    <img src="<?php echo esc_url( $thumb_url ); ?>" style="max-width: 60px; max-height: 60px;">
                                <?php else : ?>
                                    <em style="color: #999;"><?php _e( 'No thumbnail', 'digital-rise-auto-poster' ); ?></em>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <p style="padding: 15px; margin: 0; background: #f8f9fa; border-top: 1px solid #c3c4c7;">
                <strong><?php _e( 'Analysis:', 'digital-rise-auto-poster' ); ?></strong>
                <?php 
                $unique_urls = array();
                foreach ( $imported_posts as $post ) {
                    $url = get_post_meta( $post->ID, '_drap_source_image', true );
                    if ( $url ) $unique_urls[$url] = true;
                }
                $unique_count = count( $unique_urls );
                $total_count = count( $imported_posts );
                
                if ( $unique_count === 0 ) {
                    echo '<span style="color: #856404;">⚠️ ' . __( 'No image URLs stored. Images may not be enabled or feed has no images.', 'digital-rise-auto-poster' ) . '</span>';
                } elseif ( $unique_count === 1 && $total_count > 1 ) {
                    echo '<span style="color: #dc3545;">❌ ' . __( 'All posts have the SAME image URL! The RSS feed is providing the same image for all items apply full content.', 'digital-rise-auto-poster' ) . '</span>';
                } else {
                    echo '<span style="color: #28a745;">✅ ' . sprintf( __( '%d unique image URLs found for %d posts. Images should be different.', 'digital-rise-auto-poster' ), $unique_count, $total_count ) . '</span>';
                }
                ?>
            </p>
        </div>
    <?php endif; ?>

    <?php if ( $campaign_id && ! empty( $logs ) ) : ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th style="width: 150px;"><?php _e( 'Time', 'digital-rise-auto-poster' ); ?></th>
                    <th style="width: 80px;"><?php _e( 'Level', 'digital-rise-auto-poster' ); ?></th>
                    <th><?php _e( 'Message', 'digital-rise-auto-poster' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ( $logs as $log ) : ?>
                    <tr>
                        <td><?php echo date_i18n( 'M j, Y g:i a', strtotime( $log->created_at ) ); ?></td>
                        <td>
                            <span class="drap-log-level drap-log-<?php echo esc_attr( $log->level ); ?>">
                                <?php echo ucfirst( $log->level ); ?>
                            </span>
                        </td>
                        <td><?php echo esc_html( $log->message ); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php elseif ( $campaign_id ) : ?>
        <p><?php _e( 'No logs found.', 'digital-rise-auto-poster' ); ?></p>
    <?php else : ?>
        <p><?php _e( 'Select a campaign to view logs.', 'digital-rise-auto-poster' ); ?></p>
    <?php endif; ?>
</div>
