<?php
/**
 * Campaign Edit View
 * 
 * @package Digital_Rise_Auto_Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$is_edit = ! empty( $campaign );
$options = $is_edit ? maybe_unserialize( $campaign->options ) : array();
if ( ! is_array( $options ) ) $options = array();
$cats = $is_edit ? maybe_unserialize( $campaign->post_category ) : array();
$tags = $is_edit ? maybe_unserialize( $campaign->post_tags ) : array();

// Schedule options
$schedule_type = isset( $options['schedule_type'] ) ? $options['schedule_type'] : 'interval';
$schedule_days = isset( $options['schedule_days'] ) ? $options['schedule_days'] : array();
$schedule_time = isset( $options['schedule_time'] ) ? $options['schedule_time'] : '09:00';
?>
<div class="wrap drap-wrap">
    <h1>
        <?php echo $is_edit ? __( 'Edit Campaign', 'digital-rise-auto-poster' ) : __( 'Add New Campaign', 'digital-rise-auto-poster' ); ?>
    </h1>
    <a href="<?php echo admin_url( 'admin.php?page=drap-campaigns' ); ?>" class="page-title-action">
        <?php _e( '← Back to Campaigns', 'digital-rise-auto-poster' ); ?>
    </a>
    <hr class="wp-header-end">

    <?php if ( isset( $_GET['msg'] ) ) : ?>
        <div class="notice notice-success is-dismissible">
            <p><?php echo $_GET['msg'] === 'created' ? __( 'Campaign created!', 'digital-rise-auto-poster' ) : __( 'Campaign updated!', 'digital-rise-auto-poster' ); ?></p>
        </div>
    <?php endif; ?>

    <form method="post" class="drap-form">
        <?php wp_nonce_field( 'drap_save' ); ?>
        <input type="hidden" name="campaign_id" value="<?php echo $is_edit ? $campaign->id : 0; ?>">

        <div class="drap-edit-layout">
            <!-- LEFT COLUMN: Settings -->
            <div class="drap-main">
                <!-- Basic Settings -->
                <div class="drap-box">
                    <h2><?php _e( 'Basic Settings', 'digital-rise-auto-poster' ); ?></h2>
                    <table class="form-table">
                        <tr>
                            <th><label for="title"><?php _e( 'Campaign Name', 'digital-rise-auto-poster' ); ?> *</label></th>
                            <td>
                                <input type="text" id="title" name="title" class="regular-text" required
                                    value="<?php echo esc_attr( $is_edit ? $campaign->title : '' ); ?>">
                            </td>
                        </tr>
                        <tr>
                            <th><label for="status"><?php _e( 'Status', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <select id="status" name="status">
                                    <option value="inactive" <?php selected( $is_edit ? $campaign->status : 'inactive', 'inactive' ); ?>><?php _e( 'Inactive', 'digital-rise-auto-poster' ); ?></option>
                                    <option value="active" <?php selected( $is_edit ? $campaign->status : '', 'active' ); ?>><?php _e( 'Active', 'digital-rise-auto-poster' ); ?></option>
                                </select>
                                <p class="description"><?php _e( 'Active campaigns will run automatically based on schedule.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Feed Settings -->
                <div class="drap-box">
                    <h2><?php _e( 'RSS Feed', 'digital-rise-auto-poster' ); ?></h2>
                    <table class="form-table">
                        <tr>
                            <th><label for="feed_url"><?php _e( 'Feed URL', 'digital-rise-auto-poster' ); ?> *</label></th>
                            <td>
                                <input type="url" id="feed_url" name="feed_url" class="large-text" required
                                    placeholder="https://example.com/feed/"
                                    value="<?php echo esc_url( $is_edit ? $campaign->feed_url : '' ); ?>">
                                <p>
                                    <button type="button" class="button drap-validate-feed"><?php _e( 'Validate Feed', 'digital-rise-auto-poster' ); ?></button>
                                    <span class="drap-feed-result"></span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="posts_per_fetch"><?php _e( 'Posts Per Run', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <input type="number" id="posts_per_fetch" name="posts_per_fetch" class="small-text" min="1" max="100"
                                    value="<?php echo esc_attr( $is_edit ? $campaign->posts_per_fetch : 5 ); ?>">
                                <p class="description"><?php _e( 'How many posts to import each time the campaign runs.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Schedule Settings -->
                <div class="drap-box">
                    <h2><?php _e( 'Schedule', 'digital-rise-auto-poster' ); ?></h2>
                    <table class="form-table">
                        <tr>
                            <th><label><?php _e( 'Schedule Type', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <fieldset>
                                    <label style="display: block; margin-bottom: 8px;">
                                        <input type="radio" name="schedule_type" value="interval" <?php checked( $schedule_type, 'interval' ); ?>>
                                        <?php _e( 'Run every X minutes', 'digital-rise-auto-poster' ); ?>
                                    </label>
                                    <label style="display: block; margin-bottom: 8px;">
                                        <input type="radio" name="schedule_type" value="daily" <?php checked( $schedule_type, 'daily' ); ?>>
                                        <?php _e( 'Run once daily at specific time', 'digital-rise-auto-poster' ); ?>
                                    </label>
                                    <label style="display: block;">
                                        <input type="radio" name="schedule_type" value="weekly" <?php checked( $schedule_type, 'weekly' ); ?>>
                                        <?php _e( 'Run on specific days of the week', 'digital-rise-auto-poster' ); ?>
                                    </label>
                                </fieldset>
                            </td>
                        </tr>
                        <tr class="drap-schedule-interval" <?php echo $schedule_type !== 'interval' ? 'style="display:none;"' : ''; ?>>
                            <th><label for="fetch_interval"><?php _e( 'Interval', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <input type="number" id="fetch_interval" name="fetch_interval" class="small-text" min="15"
                                    value="<?php echo esc_attr( $is_edit ? $campaign->fetch_interval : 60 ); ?>">
                                <?php _e( 'minutes', 'digital-rise-auto-poster' ); ?>
                                <p class="description"><?php _e( 'Minimum 15 minutes.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                        <tr class="drap-schedule-days" <?php echo $schedule_type !== 'weekly' ? 'style="display:none;"' : ''; ?>>
                            <th><label><?php _e( 'Days', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <div class="drap-days-checkboxes">
                                    <?php
                                    $days = array(
                                        'mon' => __( 'Mon', 'digital-rise-auto-poster' ),
                                        'tue' => __( 'Tue', 'digital-rise-auto-poster' ),
                                        'wed' => __( 'Wed', 'digital-rise-auto-poster' ),
                                        'thu' => __( 'Thu', 'digital-rise-auto-poster' ),
                                        'fri' => __( 'Fri', 'digital-rise-auto-poster' ),
                                        'sat' => __( 'Sat', 'digital-rise-auto-poster' ),
                                        'sun' => __( 'Sun', 'digital-rise-auto-poster' ),
                                    );
                                    foreach ( $days as $day_key => $day_name ) : ?>
                                        <label class="drap-day-checkbox">
                                            <input type="checkbox" name="schedule_days[]" value="<?php echo $day_key; ?>"
                                                <?php checked( in_array( $day_key, (array) $schedule_days ) ); ?>>
                                            <?php echo $day_name; ?>
                                        </label>
                                    <?php endforeach; ?>
                                </div>
                                <p class="description"><?php _e( 'Select 2-4 days for optimal posting frequency.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                        <tr class="drap-schedule-time" <?php echo $schedule_type === 'interval' ? 'style="display:none;"' : ''; ?>>
                            <th><label for="schedule_time"><?php _e( 'Time', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <input type="time" id="schedule_time" name="schedule_time" 
                                    value="<?php echo esc_attr( $schedule_time ); ?>">
                                <p class="description"><?php _e( 'Server time. Current:', 'digital-rise-auto-poster' ); ?> <strong><?php echo current_time( 'H:i' ); ?></strong></p>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Post Settings -->
                <div class="drap-box">
                    <h2><?php _e( 'Post Settings', 'digital-rise-auto-poster' ); ?></h2>
                    <table class="form-table">
                        <tr>
                            <th><label for="post_status"><?php _e( 'Post Status', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <select id="post_status" name="post_status">
                                    <option value="publish" <?php selected( $is_edit ? $campaign->post_status : 'publish', 'publish' ); ?>><?php _e( 'Published', 'digital-rise-auto-poster' ); ?></option>
                                    <option value="draft" <?php selected( $is_edit ? $campaign->post_status : '', 'draft' ); ?>><?php _e( 'Draft', 'digital-rise-auto-poster' ); ?></option>
                                    <option value="pending" <?php selected( $is_edit ? $campaign->post_status : '', 'pending' ); ?>><?php _e( 'Pending', 'digital-rise-auto-poster' ); ?></option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="post_author"><?php _e( 'Author', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <?php wp_dropdown_users( array(
                                    'name' => 'post_author',
                                    'id' => 'post_author',
                                    'selected' => $is_edit ? $campaign->post_author : get_current_user_id(),
                                ) ); ?>
                            </td>
                        </tr>
                        <tr>
                            <th><?php _e( 'Categories', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <div class="drap-cats">
                                    <?php foreach ( get_categories( array( 'hide_empty' => false ) ) as $cat ) : ?>
                                        <label>
                                            <input type="checkbox" name="post_category[]" value="<?php echo $cat->term_id; ?>"
                                                <?php checked( in_array( $cat->term_id, (array) $cats ) ); ?>>
                                            <?php echo esc_html( $cat->name ); ?>
                                        </label>
                                    <?php endforeach; ?>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="post_tags"><?php _e( 'Tags', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <input type="text" id="post_tags" name="post_tags" class="large-text"
                                    placeholder="tag1, tag2, tag3"
                                    value="<?php echo esc_attr( is_array( $tags ) ? implode( ', ', $tags ) : '' ); ?>">
                                <p class="description"><?php _e( 'Comma separated', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Content Options -->
                <div class="drap-box">
                    <h2><?php _e( 'Content & Images', 'digital-rise-auto-poster' ); ?></h2>
                    <table class="form-table">
                        <tr>
                            <th><?php _e( 'Featured Image', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="import_image" <?php checked( ! empty( $options['import_image'] ) ); ?>>
                                    <?php _e( 'Import featured image', 'digital-rise-auto-poster' ); ?>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <th><?php _e( 'Fetch from Original', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="fetch_full_content" <?php checked( ! empty( $options['fetch_full_content'] ) ); ?>>
                                    <?php _e( 'Fetch image from original article page', 'digital-rise-auto-poster' ); ?>
                                </label>
                                <p class="description"><?php _e( 'If RSS feed has no image, visit the original article to get the Open Graph image.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><?php _e( 'Convert to WebP', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="convert_webp" <?php checked( ! empty( $options['convert_webp'] ) ); ?>>
                                    <?php _e( 'Convert images to WebP format', 'digital-rise-auto-poster' ); ?>
                                </label>
                                <p class="description"><?php _e( 'Smaller file size, faster loading. Requires GD or Imagick.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><?php _e( 'Image SEO', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="image_seo" <?php checked( ! empty( $options['image_seo'] ) ); ?>>
                                    <?php _e( 'Set image title/alt/description to post title', 'digital-rise-auto-poster' ); ?>
                                </label>
                                <p class="description"><?php _e( 'Better SEO for all imported images.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><?php _e( 'Source Link', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="add_source_link" <?php checked( ! empty( $options['add_source_link'] ) ); ?>>
                                    <?php _e( 'Add source link at end of content', 'digital-rise-auto-poster' ); ?>
                                </label>
                                <div style="margin-top: 10px;">
                                    <input type="text" name="source_link_text" class="regular-text"
                                        placeholder="<?php esc_attr_e( 'Source', 'digital-rise-auto-poster' ); ?>"
                                        value="<?php echo esc_attr( isset( $options['source_link_text'] ) ? $options['source_link_text'] : '' ); ?>">
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <th><?php _e( 'Post Date', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="use_original_date" <?php checked( ! empty( $options['use_original_date'] ) ); ?>>
                                    <?php _e( 'Use original date from feed', 'digital-rise-auto-poster' ); ?>
                                </label>
                            </td>
                        </tr>
                        <tr>
                            <th><?php _e( 'Feed Categories', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="feed_cats_as_tags" <?php checked( ! empty( $options['feed_cats_as_tags'] ) ); ?>>
                                    <?php _e( 'Import feed categories as post tags', 'digital-rise-auto-poster' ); ?>
                                </label>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Limits -->
                <div class="drap-box">
                    <h2><?php _e( 'Limits', 'digital-rise-auto-poster' ); ?></h2>
                    <table class="form-table">
                        <tr>
                            <th><label for="max_posts"><?php _e( 'Max Total Posts', 'digital-rise-auto-poster' ); ?></label></th>
                            <td>
                                <input type="number" id="max_posts" name="max_posts" class="small-text" min="0" max="10000"
                                    value="<?php echo esc_attr( isset( $options['max_posts'] ) ? $options['max_posts'] : 0 ); ?>">
                                <p class="description"><?php _e( 'Stop importing after this many total posts. 0 = unlimited.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                        <tr>
                            <th><?php _e( 'Pause When Limit Reached', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="pause_at_limit" <?php checked( ! empty( $options['pause_at_limit'] ) ); ?>>
                                    <?php _e( 'Automatically pause campaign when max posts reached', 'digital-rise-auto-poster' ); ?>
                                </label>
                            </td>
                        </tr>
                    </table>
                </div>

                <!-- Duplicate Handling -->
                <div class="drap-box">
                    <h2><?php _e( 'Duplicate Handling', 'digital-rise-auto-poster' ); ?></h2>
                    <table class="form-table">
                        <tr>
                            <th><?php _e( 'Allow Duplicates', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <label>
                                    <input type="checkbox" name="allow_duplicates" <?php checked( ! empty( $options['allow_duplicates'] ) ); ?>>
                                    <?php _e( 'Allow posting same content multiple times', 'digital-rise-auto-poster' ); ?>
                                </label>
                            </td>
                        </tr>
                        <?php if ( $is_edit ) : ?>
                        <tr>
                            <th><?php _e( 'Clear History', 'digital-rise-auto-poster' ); ?></th>
                            <td>
                                <button type="button" class="button drap-clear-history" data-id="<?php echo $campaign->id; ?>">
                                    <?php _e( 'Clear Import History', 'digital-rise-auto-poster' ); ?>
                                </button>
                                <p class="description"><?php _e( 'Allow re-importing all items.', 'digital-rise-auto-poster' ); ?></p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </table>
                </div>

            </div>

            <!-- RIGHT COLUMN: Sidebar -->
            <div class="drap-sidebar">
                <!-- Update/Create Button -->
                <div class="drap-box drap-box-primary">
                    <h3><?php _e( 'Publish', 'digital-rise-auto-poster' ); ?></h3>
                    <p class="submit" style="margin: 0; padding: 0;">
                        <input type="submit" name="drap_save" class="button button-primary button-hero" style="width: 100%;"
                            value="<?php echo $is_edit ? __( 'Update Campaign', 'digital-rise-auto-poster' ) : __( 'Create Campaign', 'digital-rise-auto-poster' ); ?>">
                    </p>
                </div>

                <?php if ( $is_edit ) : ?>
                    <!-- Manual Run -->
                    <div class="drap-box">
                        <h3><span class="dashicons dashicons-controls-play"></span> <?php _e( 'Manual Run', 'digital-rise-auto-poster' ); ?></h3>
                        <p><?php _e( 'Import posts now without waiting.', 'digital-rise-auto-poster' ); ?></p>
                        <button type="button" class="button button-primary drap-run-now" style="width: 100%;"
                            data-id="<?php echo $campaign->id; ?>" 
                            <?php disabled( $campaign->status !== 'active' ); ?>>
                            <span class="dashicons dashicons-controls-play"></span>
                            <?php _e( 'Run Now', 'digital-rise-auto-poster' ); ?>
                        </button>
                        <?php if ( $campaign->status !== 'active' ) : ?>
                            <p class="description" style="color: #d63638; margin-top: 8px;"><?php _e( '⚠️ Activate campaign first', 'digital-rise-auto-poster' ); ?></p>
                        <?php endif; ?>
                        <div class="drap-run-result"></div>
                    </div>

                    <!-- Campaign Info -->
                    <div class="drap-box">
                        <h3><span class="dashicons dashicons-info"></span> <?php _e( 'Campaign Info', 'digital-rise-auto-poster' ); ?></h3>
                        <ul class="drap-info">
                            <li>
                                <span class="drap-info-label"><?php _e( 'Status', 'digital-rise-auto-poster' ); ?></span>
                                <span class="drap-status drap-status-<?php echo esc_attr( $campaign->status ); ?>">
                                    <?php echo $campaign->status === 'active' ? __( 'Active', 'digital-rise-auto-poster' ) : __( 'Inactive', 'digital-rise-auto-poster' ); ?>
                                </span>
                            </li>
                            <li>
                                <span class="drap-info-label"><?php _e( 'Total Posts', 'digital-rise-auto-poster' ); ?></span>
                                <strong style="font-size: 16px;"><?php echo $campaign->total_posts; ?></strong>
                            </li>
                            <li>
                                <span class="drap-info-label"><?php _e( 'Last Run', 'digital-rise-auto-poster' ); ?></span>
                                <?php echo $campaign->last_run ? human_time_diff( strtotime( $campaign->last_run ) ) . ' ' . __( 'ago', 'digital-rise-auto-poster' ) : '<em>' . __( 'Never', 'digital-rise-auto-poster' ) . '</em>'; ?>
                            </li>
                            <li>
                                <span class="drap-info-label"><?php _e( 'Next Run', 'digital-rise-auto-poster' ); ?></span>
                                <?php 
                                if ( $campaign->status === 'active' && $campaign->next_run ) {
                                    $next = strtotime( $campaign->next_run );
                                    if ( $next > time() ) {
                                        echo '<span style="color: #00a32a;">' . human_time_diff( $next ) . '</span>';
                                    } else {
                                        echo '<span style="color: #dba617;">' . __( 'Pending...', 'digital-rise-auto-poster' ) . '</span>';
                                    }
                                } else {
                                    echo '<em>' . __( 'Not scheduled', 'digital-rise-auto-poster' ) . '</em>';
                                }
                                ?>
                            </li>
                            <li>
                                <span class="drap-info-label"><?php _e( 'Created', 'digital-rise-auto-poster' ); ?></span>
                                <?php echo date_i18n( 'M j, Y', strtotime( $campaign->created_at ) ); ?>
                            </li>
                        </ul>
                    </div>

                    <!-- Recent Activity -->
                    <div class="drap-box">
                        <h3><span class="dashicons dashicons-list-view"></span> <?php _e( 'Recent Activity', 'digital-rise-auto-poster' ); ?></h3>
                        <?php if ( ! empty( $logs ) ) : ?>
                            <ul class="drap-logs-mini">
                                <?php foreach ( array_slice( $logs, 0, 6 ) as $log ) : ?>
                                    <li class="drap-log-<?php echo esc_attr( $log->level ); ?>">
                                        <span class="drap-log-msg"><?php echo esc_html( wp_trim_words( $log->message, 6 ) ); ?></span>
                                        <span class="drap-log-time"><?php echo human_time_diff( strtotime( $log->created_at ) ); ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <a href="<?php echo admin_url( 'admin.php?page=drap-logs&campaign_id=' . $campaign->id ); ?>" class="button" style="width: 100%; text-align: center; margin-top: 10px;">
                                <?php _e( 'View All Logs', 'digital-rise-auto-poster' ); ?>
                            </a>
                        <?php else : ?>
                            <p style="text-align: center; color: #666;"><em><?php _e( 'No activity yet.', 'digital-rise-auto-poster' ); ?></em></p>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <!-- Donate -->
                <div class="drap-box drap-donate-box">
                    <h3><span class="dashicons dashicons-heart"></span> <?php _e( 'Support Us', 'digital-rise-auto-poster' ); ?></h3>
                    <p><?php _e( 'Help us improve this plugin!', 'digital-rise-auto-poster' ); ?></p>
                    <a href="https://digital-rise-solutions.com/pay-easily-with-usdt-trc20-using-redotpay/" target="_blank" class="button button-primary" style="width: 100%; text-align: center;">
                        <?php _e( 'Donate with USDT', 'digital-rise-auto-poster' ); ?>
                    </a>
                </div>
            </div>
        </div>
    </form>
</div>

<script>
jQuery(document).ready(function($) {
    $('input[name="schedule_type"]').on('change', function() {
        var type = $(this).val();
        $('.drap-schedule-interval, .drap-schedule-days, .drap-schedule-time').hide();
        if (type === 'interval') {
            $('.drap-schedule-interval').show();
        } else if (type === 'daily') {
            $('.drap-schedule-time').show();
        } else if (type === 'weekly') {
            $('.drap-schedule-days, .drap-schedule-time').show();
        }
    });
});
</script>
