<?php
/**
 * Campaigns List View
 * 
 * @package Digital_Rise_Auto_Poster
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap drap-wrap">
    <h1 class="wp-heading-inline">
        <span class="dashicons dashicons-rss"></span>
        <?php _e( 'Digital Rise Auto Poster', 'digital-rise-auto-poster' ); ?>
    </h1>
    <a href="<?php echo admin_url( 'admin.php?page=drap-edit' ); ?>" class="page-title-action">
        <?php _e( 'Add New Campaign', 'digital-rise-auto-poster' ); ?>
    </a>
    <hr class="wp-header-end">

    <!-- Branding & Donate -->
    <div class="drap-header-info">
        <div class="drap-branding">
            <strong>Digital Rise Solutions</strong> - 
            <?php _e( 'Professional RSS Auto Posting', 'digital-rise-auto-poster' ); ?>
        </div>
        <a href="https://digital-rise-solutions.com/pay-easily-with-usdt-trc20-using-redotpay/" target="_blank" class="button button-primary drap-donate-btn">
            <span class="dashicons dashicons-heart"></span>
            <?php _e( 'Support Us - Donate', 'digital-rise-auto-poster' ); ?>
        </a>
    </div>

    <!-- Stats -->
    <div class="drap-stats">
        <div class="drap-stat">
            <span class="drap-stat-num"><?php echo esc_html( $stats['total_campaigns'] ); ?></span>
            <span class="drap-stat-label"><?php _e( 'Campaigns', 'digital-rise-auto-poster' ); ?></span>
        </div>
        <div class="drap-stat">
            <span class="drap-stat-num"><?php echo esc_html( $stats['active_campaigns'] ); ?></span>
            <span class="drap-stat-label"><?php _e( 'Active', 'digital-rise-auto-poster' ); ?></span>
        </div>
        <div class="drap-stat">
            <span class="drap-stat-num"><?php echo esc_html( $stats['total_posts'] ); ?></span>
            <span class="drap-stat-label"><?php _e( 'Posts Created', 'digital-rise-auto-poster' ); ?></span>
        </div>
    </div>

    <!-- Campaigns Table -->
    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th><?php _e( 'Campaign', 'digital-rise-auto-poster' ); ?></th>
                <th><?php _e( 'Status', 'digital-rise-auto-poster' ); ?></th>
                <th><?php _e( 'Feed', 'digital-rise-auto-poster' ); ?></th>
                <th><?php _e( 'Posts', 'digital-rise-auto-poster' ); ?></th>
                <th><?php _e( 'Last Run', 'digital-rise-auto-poster' ); ?></th>
                <th><?php _e( 'Actions', 'digital-rise-auto-poster' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ( empty( $campaigns ) ) : ?>
                <tr>
                    <td colspan="6" style="text-align: center; padding: 40px;">
                        <p><?php _e( 'No campaigns yet.', 'digital-rise-auto-poster' ); ?></p>
                        <a href="<?php echo admin_url( 'admin.php?page=drap-edit' ); ?>" class="button button-primary">
                            <?php _e( 'Create Your First Campaign', 'digital-rise-auto-poster' ); ?>
                        </a>
                    </td>
                </tr>
            <?php else : ?>
                <?php foreach ( $campaigns as $c ) : ?>
                    <tr data-id="<?php echo esc_attr( $c->id ); ?>">
                        <td>
                            <strong>
                                <a href="<?php echo admin_url( 'admin.php?page=drap-edit&id=' . $c->id ); ?>">
                                    <?php echo esc_html( $c->title ); ?>
                                </a>
                            </strong>
                        </td>
                        <td>
                            <span class="drap-status drap-status-<?php echo esc_attr( $c->status ); ?>">
                                <?php echo $c->status === 'active' ? __( 'Active', 'digital-rise-auto-poster' ) : __( 'Inactive', 'digital-rise-auto-poster' ); ?>
                            </span>
                        </td>
                        <td>
                            <code><?php echo esc_html( wp_parse_url( $c->feed_url, PHP_URL_HOST ) ); ?></code>
                        </td>
                        <td><?php echo esc_html( $c->total_posts ); ?></td>
                        <td>
                            <?php 
                            if ( $c->last_run ) {
                                echo esc_html( human_time_diff( strtotime( $c->last_run ), current_time( 'timestamp' ) ) ) . ' ago';
                            } else {
                                _e( 'Never', 'digital-rise-auto-poster' );
                            }
                            ?>
                        </td>
                        <td class="drap-actions">
                            <?php if ( $c->status === 'active' ) : ?>
                                <button type="button" class="button drap-run-now" data-id="<?php echo esc_attr( $c->id ); ?>">
                                    <span class="dashicons dashicons-controls-play"></span>
                                    <?php _e( 'Run', 'digital-rise-auto-poster' ); ?>
                                </button>
                            <?php endif; ?>
                            <button type="button" class="button drap-toggle" data-id="<?php echo esc_attr( $c->id ); ?>">
                                <?php echo $c->status === 'active' ? __( 'Pause', 'digital-rise-auto-poster' ) : __( 'Activate', 'digital-rise-auto-poster' ); ?>
                            </button>
                            <a href="<?php echo admin_url( 'admin.php?page=drap-edit&id=' . $c->id ); ?>" class="button">
                                <?php _e( 'Edit', 'digital-rise-auto-poster' ); ?>
                            </a>
                            <button type="button" class="button drap-delete" data-id="<?php echo esc_attr( $c->id ); ?>">
                                <span class="dashicons dashicons-trash"></span>
                            </button>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Footer -->
    <div class="drap-footer">
        <p>
            <strong>Digital Rise Auto Poster Solutions</strong> v<?php echo DRAP_VERSION; ?> | 
            <a href="https://digital-rise-solutions.com" target="_blank">Digital Rise Solutions</a> | 
            <a href="https://digital-rise-solutions.com/pay-easily-with-usdt-trc20-using-redotpay/" target="_blank" class="drap-donate-link">
                <span class="dashicons dashicons-heart"></span> <?php _e( 'Donate', 'digital-rise-auto-poster' ); ?>
            </a>
        </p>
    </div>
</div>
