/**
 * Digital Rise Auto Poster - Admin JS
 */

(function($) {
    'use strict';

    // Run Now - with history of created posts
    $(document).on('click', '.drap-run-now', function(e) {
        e.preventDefault();
        
        var $btn = $(this);
        var $result = $btn.parent().find('.drap-run-result');
        var id = $btn.data('id');
        
        // Create result container if not exists
        if (!$result.length) {
            $result = $('<div class="drap-run-result"></div>');
            $btn.after($result);
        }
        
        $btn.prop('disabled', true).text(drap.running);
        
        $.post(drap.ajax, {
            action: 'drap_run_now',
            nonce: drap.nonce,
            campaign_id: id
        }, function(response) {
            if (response.success) {
                var data = response.data;
                
                if (data.no_items) {
                    // No new items
                    var existingContent = $result.html() || '';
                    var noItemsHtml = '<div class="drap-no-items" style="margin-top:10px;padding-top:10px;border-top:1px solid rgba(0,0,0,0.1);">✓ ' + data.message + '</div>';
                    
                    if (existingContent && !existingContent.includes('drap-no-items')) {
                        $result.addClass('success').html(existingContent + noItemsHtml).show();
                    } else {
                        $result.addClass('success').html('<div class="drap-no-items">✓ ' + data.message + '</div>').show();
                    }
                } else if (data.posts && data.posts.length > 0) {
                    // Multiple posts created
                    var postsHtml = '';
                    for (var i = 0; i < data.posts.length; i++) {
                        var post = data.posts[i];
                        postsHtml += '<div class="drap-created-post">' +
                            '<span class="dashicons dashicons-yes-alt" style="color:#46b450;"></span> ' +
                            '<strong>' + post.title + '</strong> ' +
                            '<a href="' + post.url + '" target="_blank">View →</a>' +
                            '</div>';
                    }
                    
                    var existingContent = $result.find('.drap-created-post').length ? 
                        $result.html().replace(/<div class="drap-no-items".*?<\/div>/g, '').replace(/<div class="drap-remaining".*?<\/div>/g, '') : '';
                    
                    $result.removeClass('error').addClass('success').html(existingContent + postsHtml).show();
                    
                    if (typeof data.remaining !== 'undefined') {
                        $result.find('.drap-remaining').remove();
                        $result.append('<div class="drap-remaining" style="margin-top:8px;padding-top:8px;border-top:1px solid rgba(0,0,0,0.1);font-size:11px;color:#666;text-align:center;">' + 
                            data.remaining + ' items remaining</div>');
                    }
                }
                
                // Update stats on list page
                if ($('.drap-stats').length && data.posts) {
                    var $postsCount = $('.drap-stat-num').eq(2);
                    if ($postsCount.length) {
                        $postsCount.text(parseInt($postsCount.text()) + data.posts.length);
                    }
                }
            } else {
                $result.addClass('error').html(
                    '<div class="drap-error-msg" style="color:#dc3232;">✗ ' + response.data + '</div>'
                ).show();
            }
        }).fail(function() {
            $result.addClass('error').html('<div class="drap-error-msg">Connection error. Please try again.</div>').show();
        }).always(function() {
            $btn.prop('disabled', false).html('<span class="dashicons dashicons-controls-play"></span> Run Now');
        });
    });
    
    // Validate Feed
    $(document).on('click', '.drap-validate-feed', function(e) {
        e.preventDefault();
        
        var $btn = $(this);
        var $result = $('.drap-feed-result');
        var url = $('#feed_url').val();
        
        if (!url) {
            $result.removeClass('valid').addClass('error').text('Enter a URL first');
            return;
        }
        
        $btn.prop('disabled', true).text('Validating...');
        $result.removeClass('valid error').text('');
        
        $.post(drap.ajax, {
            action: 'drap_validate_feed',
            nonce: drap.nonce,
            url: url
        }, function(response) {
            if (response.success) {
                $result.addClass('valid').text('✓ Valid: ' + response.data.title + ' (' + response.data.items + ' items)');
            } else {
                $result.addClass('error').text('✗ ' + response.data);
            }
        }).always(function() {
            $btn.prop('disabled', false).text('Validate Feed');
        });
    });
    
    // Delete Campaign
    $(document).on('click', '.drap-delete', function(e) {
        e.preventDefault();
        
        if (!confirm(drap.confirm_delete)) return;
        
        var $btn = $(this);
        var $row = $btn.closest('tr');
        var id = $btn.data('id');
        
        $row.addClass('drap-loading');
        
        $.post(drap.ajax, {
            action: 'drap_delete',
            nonce: drap.nonce,
            campaign_id: id
        }, function(response) {
            if (response.success) {
                $row.fadeOut(300, function() {
                    $(this).remove();
                    if ($('tbody tr').length === 0) {
                        location.reload();
                    }
                });
            } else {
                alert(response.data);
                $row.removeClass('drap-loading');
            }
        });
    });
    
    // Toggle Status
    $(document).on('click', '.drap-toggle', function(e) {
        e.preventDefault();
        
        var $btn = $(this);
        var $row = $btn.closest('tr');
        var id = $btn.data('id');
        
        $btn.prop('disabled', true);
        
        $.post(drap.ajax, {
            action: 'drap_toggle',
            nonce: drap.nonce,
            campaign_id: id
        }, function(response) {
            if (response.success) {
                var status = response.data.status;
                var $status = $row.find('.drap-status');
                
                $status.removeClass('drap-status-active drap-status-inactive')
                       .addClass('drap-status-' + status)
                       .text(status === 'active' ? 'Active' : 'Inactive');
                
                $btn.text(status === 'active' ? 'Pause' : 'Activate');
                
                // Toggle Run button
                if (status === 'active') {
                    if ($row.find('.drap-run-now').length === 0) {
                        var runBtn = '<button type="button" class="button drap-run-now" data-id="' + id + '"><span class="dashicons dashicons-controls-play"></span> Run</button>';
                        $row.find('.drap-actions').prepend(runBtn);
                    }
                } else {
                    $row.find('.drap-run-now').remove();
                }
            }
        }).always(function() {
            $btn.prop('disabled', false);
        });
    });
    
    // Clear History
    $(document).on('click', '.drap-clear-history', function(e) {
        e.preventDefault();
        
        if (!confirm(drap.confirm_clear)) return;
        
        var $btn = $(this);
        var id = $btn.data('id');
        
        $btn.prop('disabled', true).text('Clearing...');
        
        $.post(drap.ajax, {
            action: 'drap_clear_history',
            nonce: drap.nonce,
            campaign_id: id
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
            } else {
                alert(response.data);
            }
        }).always(function() {
            $btn.prop('disabled', false).text('Clear Import History');
        });
    });

})(jQuery);
